/*
 * MosP - Mind Open Source Project         http://www.mosp.jp/
 * Copyright (C) 1987-2009 MIND Co., Ltd.  http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.payroll.bonus.action;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Calendar;
import java.util.Iterator;
import java.math.BigDecimal;

import org.apache.commons.csv.CSVParser;

import jp.mosp.payroll.base.Employee;
import jp.mosp.payroll.base.PayrollAction;

import jp.mosp.payroll.dao.PtCurrentDao;
import jp.mosp.payroll.dao.CmCompanyDao;
import jp.mosp.payroll.dao.CmPaymentMeansDao;
import jp.mosp.payroll.dao.CmSocInsuranceDao;

import jp.mosp.payroll.dto.PtCurrentDto;
import jp.mosp.payroll.dto.CmCompanyDto;
import jp.mosp.payroll.dto.CmPaymentMeansDto;
import jp.mosp.payroll.dto.CmSocInsuranceDto;

import jp.mosp.system.dao.MKaisyaDao;
import jp.mosp.system.dto.MKaisyaDto;

import jp.mosp.payroll.bonus.dto.PdPaymentDto;
import jp.mosp.payroll.bonus.dto.PmExtraDto;


import jp.mosp.payroll.bonus.dao.PdBonusDao;
import jp.mosp.payroll.bonus.dao.PhBounsDao;
import jp.mosp.payroll.bonus.dao.PmExtraDao;

import jp.mosp.payroll.bonus.dto.PdBonusDto;
import jp.mosp.payroll.bonus.dto.PhBounsDto;
import jp.mosp.payroll.bonus.dto.PsDetailDto;
import jp.mosp.payroll.bonus.dto.PhBasisDto;
import jp.mosp.payroll.bonus.vo.BonusCalcVo;
import jp.mosp.payroll.bonus.BonusConst;

import jp.mosp.payroll.base.PayrollConst;

import jp.mosp.common.common.FileUploadUtility;
import jp.mosp.common.common.MospConst;
import jp.mosp.common.common.MospException;
import jp.mosp.common.common.MospUtility;
import jp.mosp.common.common.ValidateUtility;
import jp.mosp.common.dao.MosPConfDao;
import jp.mosp.common.dto.MosPConfDto;

import jp.mosp.legal.LegalConst;
import jp.mosp.legal.LegalUtility;

public class BonusCalcAction extends PayrollAction {
	// tB[h
	// vZsCX^X
	protected PdPaymentDto pdPaymentDto;	// Ώۋ^f[^
	// vZsCX^X(ܗ^)
	protected PhBounsDto phBounsDto;	// Ώۏܗ^f[^

	// R}h
	private static final String CMD_BONUS_CALC_SHOW   = "P2001";
	private static final String CMD_BONUS_CALC_UPLOAD = "P2002";
	private static final String CMD_BONUS_CALC_DELETE = "P2003";
	private static final String CMD_BONUS_CALC_TAX    = "P2004";
	private static final String CMD_BONUS_CALC_TOTAL  = "P2005";
	
	public String[][] aryBonusHeaderItem;
	
	private String[] aryCsvData;
	private String[] aryHeaderData;
	private String[] aryRegistCsvData;
	private String[] aryRegistHeaderData;
	private String[] aryHeaderNo;
	private int csvRegistDataCount = 0;
	private int csvDataCount = 0;
	
	private PhBounsDto searchDto;
	private boolean isAddRegistData = true;

	protected PhBasisDto phBasisDto;
	
	/** p֌Wz΁ApŒ` **/
	protected int befHealthPremium   = 0; // ܗ^Ώ۔NNی(ΏۓȊO)
	protected int befNursingPremium  = 0;	// ܗ^Ώ۔Nی(ΏۓȊO)
	protected int befPensionPremium  = 0;	// ܗ^Ώ۔NNی(ΏۓȊO)
	protected int befFundPremium     = 0;	// ܗ^Ώ۔NNی(ΏۓȊO)
	protected int befSocInsPremium   = 0;	// ܗ^Ώ۔NЉیz(ΏۓȊO)
	protected int bank1Amount = 0;	// s1Uz
	protected int bank2Amount = 0;	// s2Uz
	protected int cashAmount  = 0;	// xz
	// Џ()
	protected float  ratioHealthPremium   = 0;	// Nی 
	protected float  ratioNursingPremium  = 0;	// ی
	protected float  ratioPensionPremium  = 0;	// N
	protected float  ratioFundPremium     = 0;	// N
	protected float  ratioUnemployPremium = 0;	// ٗpی
	protected String  fundParticipation    = "";	// N
	protected Date startDateOfYear;	// NJn
	protected Date lastDateOfYear ;	// NŏI
	protected String kCode;
	protected Date   targetMonth    ;
	// אݒ(ܗ^)
	protected Map<String, Map<String, PsDetailDto>> mapBonusDetailAll;
	Date befTargetMonth;	//@ỎېőΏۊz擾pN
	

	
	/**
	 * ANV
	 */
	public void action() throws Exception {
		// DBRlNV擾
		getConnection();
		// PAYROLLmF
		confirmPayrollAuth();
		// VO̎擾
		BonusCalcVo vo;
		Object obj = session.getAttribute(MospConst.ATT_FORMER_VO);
		if (obj instanceof BonusCalcVo) {
			vo = (BonusCalcVo)obj;
		} else {
			vo = new BonusCalcVo();
		}
		
		vo.clearMessage();
		vo.clearErrField();
		vo.initVo(cfg, msg, cmd, aspUser, user);
		
		// VOyуtH[hURL̐ݒ
		setVo(vo);
		setUrl(vo.getRetUrl());
		
		session.setAttribute(MospConst.ATT_FORMER_VO, vo);
		// R}h̏
		if (cmd.equals(CMD_BONUS_CALC_SHOW)) {
			// Nv_Eݒ(vZN)
			setYearMonth  (vo, getCalcCurrent(),true);
			// Xg擾
			vo.aryPltStationAll = getStationArrayAll();
		} else 	if (cmd.equals(CMD_BONUS_CALC_UPLOAD)) {
			// t@Cݒ
			vo.setUploadFile(multipartFieldList);
			// Ώ۔N擾
			setTargetMonth(vo);
			// ܗ^Abv[h
			upload(vo);
		} else 	if (cmd.equals(CMD_BONUS_CALC_TAX)) {
			// N̐ݒ
			vo.setYearParams(request);
			// Ώ۔NAܗ^xݒ
			setTargetMonth(vo);
			// @TvZ
			calcLegalDeduction(vo);
			
		} else 	if (cmd.equals(CMD_BONUS_CALC_TOTAL)) {
			// N̐ݒ
			vo.setYearParams(request);
			// Ώ۔NAܗ^xݒ
			setTargetMonth(vo);
			// m菈
			calcTotal(vo);
		} else if (cmd.equals(CMD_BONUS_CALC_DELETE)) {
			// NGXgݒ
			vo.setYearParams(request);
			// Ώ۔N擾
			setTargetMonth(vo);
			// 폜(vZN)
			delete(vo);

		} else {
			throw new MospException(MospConst.EX_CMD_INVALID);
		}
	}
	
	/**
	 * Nݒ
	 * @param vo          ݒΏVO
	 * @param calcCurrent vZ
	 */
	private void setYearMonth(BonusCalcVo vo, Date calcCurrent,boolean isSetPulldown) {
		// v_E擾
		vo.aryPltYear  = getYearArrayLong(MospUtility.getYear(calcCurrent));
		vo.aryPltMonth = getMonthArray();
		vo.aryPltDay   = getDayArray();
		if (isSetPulldown) {
			// Nݒ
			vo.setPltYear(String.valueOf(MospUtility.getYear(calcCurrent)));
			vo.setPltMonth(String.valueOf(MospUtility.getMonth(calcCurrent)));
			vo.setPltDay(String.valueOf(MospUtility.getDay(calcCurrent)));
			vo.setPltDetailYear (String.valueOf(MospUtility.getYear(calcCurrent)));
			vo.setPltDetailMonth(String.valueOf(MospUtility.getMonth(calcCurrent)));
			vo.setPltDetailDay  (String.valueOf(MospUtility.getDay(calcCurrent)));

		}
	}
	
	/**
	 * Abv[h
	 * @param vo
	 */
	private void upload (BonusCalcVo vo)  throws Exception {
		// DBRlNV擾
		getConnection();
		// ^wb_[ڎ擾
		aryBonusHeaderItem = getBonusUploadHeadItem();
		// N̊mF
		chkRegsitDate(vo);
		// t@C^Cv`FbN
		if (vo.getFilUploadFile().getName().matches(".*" + ".csv" + ".*")) {
			// csvp[Xt@C擾
			CSVParser csvp = FileUploadUtility.parseCSVData(vo.getFilUploadFile());
			String[] lineHead;
			lineHead = getCSVHeadData(csvp);
			String[] lineData;
			boolean isInsertData = true;
			// wb_쐬
			createUploadHeader(vo,lineHead);
			// f[^쐬
			while (isInsertData) {
				lineData = getCSVData(csvp,csvDataCount);
				if (lineData != null) {
					// f[^쐬
					if (createUploadData(vo, lineData)) {
						// Ј݊mF
						if(chkEmploymentData(vo) == false) {
							csvDataCount++;
							// f[^sɃG[ꍇ͂̍so^Ȃ
							continue;
						}
						// PH_BONUSݒ
						setPhBonus(vo);
						// vIG[mF(f[^)
						chkErrorData(vo);
						// Abv[h\G[mF
						chkUploadErrorData(vo);
						// UD_BONUSo^
						uploadData(vo);
					}
					csvDataCount++;
				} else {
					isInsertData = false;
				}
			}
			if (csvRegistDataCount == 0) {
				// f[^G[
				String errMessage = MospUtility.getMessage(msg, BonusConst.MSG_NO_CSV_DATA, "");
				addErrMessage(errMessage);
				throw new MospException(MospConst.EX_PARAMS_INVALID);
			}
			// bZ[Wݒ
			vo.setMessage(MospUtility.getMessage(msg, BonusConst.MSG_CSV_UPLOAD,String.valueOf(csvRegistDataCount)));
		} else {
			// t@C^CvG[
			String errMessage = MospUtility.getMessage(msg, BonusConst.MSG_INVALID_FILE_TYPE, "");
			addErrMessage(errMessage);
			throw new MospException(MospConst.EX_PARAMS_INVALID);
		}
	}
	
	/**
	 * Ώ۔Nݒ
	 * @param vo          ΏVO
	 * @param targetMonth ݒN
	 * @throws Exception
	 */
	public void setTargetMonth(BonusCalcVo vo) throws Exception {
		// vZN
		vo.setCalcDate();
		// ܗ^x
		vo.setPayday();
	}

	
	/**
	 * o^ÓmF
	 * @param vo
	 * @throws Exception 
	 */
	protected void chkRegsitDate(BonusCalcVo vo) throws Exception {
		// x̑ÓmF
		vo.checkTargetDate();
		// vZNmF
//		checkCalcCurrentAfter(vo.getCalcDate());
	}
	
	/**
	 * ܗ^DTOݒ
	 * @param vo@@ΏVO
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	protected void setPhBonus(BonusCalcVo vo) throws SQLException, IllegalAccessException, NoSuchFieldException {
		// ЈR[h݃`FbN(PH_BONUST)
		PhBounsDao phBounsDao = new PhBounsDao(cfg, cmd, aspUser, user, conn);
		phBounsDao.initDao(cfg, cmd, aspUser, user, conn);
		searchDto = phBounsDao.findForKey(vo.getKCode(), vo.getPayday());
		// O[oDtoɐݒ
		if (searchDto == null) {
			this.phBounsDto = new PhBounsDto();
//			this.phBounsDto.setPositionCode(phBasisDto.getPositionCode());
		} else {
			this.phBounsDto = searchDto;
		}
	}
	
	/**
	 * vIG[mF(f[^)
	 * @param vo
	 * @throws MospException
	 */
	protected void chkErrorData(BonusCalcVo vo) throws MospException {
		// ЈR[hwb_擾`FbN
		if (vo.getIdxKCode() == 99) {
			// L[̎擾G[
			String errMessage = MospUtility.getMessage(msg, BonusConst.MSG_NO_UPLOAD_KEY, "ЈR[h" + "(" + BonusConst.UP_K_CODE + ")");
			addErrMessage(errMessage);
			throw new MospException(MospConst.EX_PARAMS_INVALID);
		}
		// wb_ƒl̐ك`FbN
		if (aryHeaderData.length != aryCsvData.length) {
			String errMessage = MospUtility.getMessage(msg, BonusConst.MSG_INVALID_CSV_COUNT, String.valueOf(csvDataCount + 1));
			addErrMessage(errMessage);
			throw new MospException(MospConst.EX_PARAMS_INVALID);
		}
	}
	
	/**
	 * Abv[h\f[^擾
	 * @param vo
	 * @throws Exception 
	 */
	protected void chkUploadErrorData(BonusCalcVo vo) throws Exception {
		// G[mFȌԂi[
		ArrayList<String> listHeadItem = new ArrayList<String>();
		ArrayList<String> listDataItem = new ArrayList<String>();
		for (int i = 0; i < aryCsvData.length; i++ ) {
			// f[^ÓmF
			isAddRegistData = validate(aryCsvData[i],aryHeaderData[i],i,csvDataCount, vo);
			if (isAddRegistData) {
				// אݒmF
				if (!aryHeaderData[i].equals(BonusConst.UP_K_CODE)) {
					isAddRegistData = chkNoSettingDetail(i);
				}
				if (isAddRegistData) {
					//f[^̂ݎ擾
					listHeadItem.add(aryHeaderNo[i]);
					listDataItem.add(aryCsvData[i]);
				}
			}
			// 
			isAddRegistData = true;
		}
		// o^zݒ
		aryRegistHeaderData = new String[listHeadItem.size()];
		aryRegistCsvData = new String[listDataItem.size()];
		
		for (int i = 0; i < listHeadItem.size(); i++) {
			
			String headerData = listHeadItem.get(i);
			String csvData = listDataItem.get(i);
			aryRegistHeaderData[i] = headerData;
			aryRegistCsvData[i] = csvData;
		}
	}
	
	/**
	 * אݒ肪ȂڊmF
	 * @param vo PayCalculateVoCX^X
	 * @throws Exception
	 */
	private boolean chkNoSettingDetail(int idx) throws Exception {
		// vZ
		boolean isRegist = true;
		// IꂽЈ̌ٗp敪Eʂ׍ڂ̃}bv擾
		Map<String, PsDetailDto> mapDetail = getMapBonusDetail();
		if (mapDetail == null) {
			// ݒ肪؂ĂȂꍇ̓G[
//			String errMessage = MospUtility.getMessage(msg, BonusConst.MSG_NO_DETAIL_DATA, this.phBounsDto.getEmploymentType());
//			addErrMessage(errMessage);
			isRegist = false;
			return isRegist;
		}
		PsDetailDto PsDetailDto = mapDetail.get(aryHeaderData[idx]);
		// ݒ肪Ȃz
		if (PsDetailDto == null) {
			if (!aryCsvData[idx].equals("0")) {
				// ݒ肪̂ɂO~łȂꍇ̓G[
				String errMessage = MospUtility.getMessage(msg, BonusConst.MSG_NOT_UP_EMP_TYPE,
						aryHeaderData[idx]+ BonusConst.KEY_SEPARATOR + String.valueOf(csvDataCount + 1)
				);
				addErrMessage(errMessage);
				isRegist = false;
				
			}
		}
		return isRegist;
	}

	/**
	 * Abv[hf[^XV
	 * @param vo
	 * @throws Exception
	 */
	protected void uploadData(BonusCalcVo vo) throws Exception {
		PhBounsDao phBounsDao = new PhBounsDao(cfg, cmd, aspUser, user, conn);
		phBounsDao.initDao(cfg, cmd, aspUser, user, conn);
		if (aryRegistCsvData.length != 0) {
			if (searchDto == null) {
				// VKo^
//				phBounsDao.insertUpload(aryRegistHeaderData, aryRegistCsvData, vo.getCalcDate(), vo.getPayday(), phBasisDto.getKName()
//						, phBasisDto.getStationCode(), phBasisDto.getEmploymentType(), phBasisDto.getPositionCode()
//						);
			} else {
//				// XV
//				phBounsDao.updateUpload(aryRegistHeaderData, aryRegistCsvData, vo.getKCode(), vo.getCalcDate(), vo.getPayday(), phBasisDto.getKName()
//						, phBasisDto.getStationCode(), phBasisDto.getEmploymentType(), phBasisDto.getPositionCode());
			}
			// R~bg
			commit();
			csvRegistDataCount ++;
		}

	}
	
	/**
	 * Abv[hpz쐬iwb_j
	 * @param vo PayCalculateVoCX^X
	 * @throws Exception
	 */
	private boolean createUploadHeader(BonusCalcVo vo,String[] line) throws Exception {
		aryHeaderNo   = new String[line.length];
		aryHeaderData = new String[line.length];
		aryHeaderData = line;
		// ЈR[h݃`FbNp
		vo.setIdxKCode(99);
		// wb_[g`FbN
		for (int i = 0; i < aryHeaderData.length; i++) {
			if(vo.checkHeadData(aryHeaderData[i],aryBonusHeaderItem)) {
				aryHeaderNo  [i] = vo.getHeadNo(aryHeaderData[i],aryBonusHeaderItem,i);
			} else {
				// wb_sG[
				String errMessage = MospUtility.getMessage(msg, BonusConst.MSG_INVALID_CSV_HEAD, aryHeaderData[i]);
				addErrMessage(errMessage);
				throw new MospException(MospConst.EX_PARAMS_INVALID);
			}
		}
		// wb_dmF
		chkDeplicateHeader();
		return true;
	}
	
	/**
	 * wb_[dmF
	 * @throws MospException
	 */
	protected void chkDeplicateHeader() throws MospException {
		for (int i = 0; i < aryHeaderNo.length; i++) {
			for (int j = i+1; j < aryHeaderNo.length; j++) {
				if (aryHeaderNo[i].equals(aryHeaderNo[j])) {
					// wb_dG[
					String errMessage = MospUtility.getMessage(msg, BonusConst.MSG_INVALID_HEAD, aryHeaderData[i]);
					addErrMessage(errMessage);
					throw new MospException(MospConst.EX_PARAMS_INVALID);
				}
			}
		}
	}
	
	/**
	 * Abv[hpz쐬if[^j
	 * @param vo PayCalculateVoCX^X
	 * @throws Exception
	 */
	private boolean createUploadData(BonusCalcVo vo,String[] line) throws Exception {
		// f[^s擾
		aryCsvData = new String[line.length];
		aryCsvData = line;
		for (int i = 0; i < aryCsvData.length; i++ ) {
			// L[f[^擾
			vo.setKeyData(aryCsvData[i], i);
		}
		return true;
	}
	
	/**
	 * Ј݊mF
	 * @param vo
	 * @throws Exception
	 */
	public boolean chkEmploymentData(BonusCalcVo vo)
		throws Exception
	{
		boolean isRegist = true;
		// ЈR[hݒ
		if (vo.getKCode() == null) {
			// L[̎擾G[
			String errMessage = MospUtility.getMessage(msg, BonusConst.MSG_NO_UPLOAD_KEY, "ЈR[h" + "(" + BonusConst.UP_K_CODE + ")");
			addErrMessage(errMessage);
			isRegist = false;
		}
		// ЈR[h݃`FbN(l)
		Employee employee = getUpdateBasisHistory(vo.getKCode(), getEndDate(vo.getCalcDate()));
		if (employee == null) {
			// o^ЈR[hG[
			String errMessage = MospUtility.getMessage(msg, BonusConst.MSG_NO_UPLOAD_HUMAN, String.valueOf(csvDataCount + 1));
			addErrMessage(errMessage);
			isRegist = false;
			return isRegist;
		}
		// ސEĂЈ̏ꍇG[
//		if (phBasisDto.getRetirementDate() != null && getTimeRemainder(
//				phBasisDto.getRetirementDate(), getStartDate(vo.getCalcDate())) < 0) {
//			String errMessage = MospUtility.getMessage(msg, BonusConst.MSG_UP_RETIRED, String.valueOf(csvDataCount + 1));
//			addErrMessage(errMessage);
//			isRegist = false;
//		}
		return isRegist;
	}
	
	/**
	 * csvf[^̑ÓmF
	 * @throws MospException
	 */
	public boolean validate(String value, String aryHeaderName,int idx, int csvRowCount, BonusCalcVo vo) throws MospException {
		// ݒ
		int rowCount = csvRowCount;
		rowCount += 1;
		// G[̐ݒ
		String errReplace = aryHeaderName + "," + String.valueOf(rowCount);
		if (idx != vo.getIdxKCode()) {
			// l̑Ó`FbN
			checkCsvNumeric(value, errReplace);
			checkCsvLength(value, BonusCalcVo.LEN_AMOUNT, aryHeaderName, rowCount);
		}
		return isAddRegistData;
	}
	
	/**
	 * ^CvmF(lFdouble)
	 * @param value mFΏە
	 * @param name  mFΏۖ
	 * @param id    mFΏۃtB[hID
	 * @throws MospException
	 */
	protected void checkCsvNumeric(String value, String name) throws MospException {
		if (!ValidateUtility.chkNumeric(value)) {
			String errMsg = MospUtility.getMessage(msg, "WC0022", name);
			addErrMessage(errMsg);
			isAddRegistData = false;
		}
	}
	
	/**
	 * 񒷊mF(ő啶)
	 * @param value     mFΏە
	 * @param maxLength ő啶
	 * @param name      mFΏۖ
	 * @param id        mFΏۃtB[hID
	 * @throws MospException
	 */
	protected void checkCsvLength(String value, int maxLength, String name, int idx) throws MospException {
		String regex = ".{0," + String.valueOf(maxLength) + "}";
		if (!ValidateUtility.chkRegex(regex, value)) {
			String errMsg = MospUtility.getMessage(msg, "WC0021", name + MospConst.DATA_SEPARATOR + String.valueOf(maxLength) + MospConst.DATA_SEPARATOR + idx);
			addErrMessage(errMsg);
			isAddRegistData = false;
		}
	}
	
	/**
	 * wb_ڐݒ
	 */
	protected String[][] getBonusUploadHeadItem() {
		ArrayList<String> listItem = new ArrayList<String>();
		listItem.add(BonusConst.UP_K_CODE);
		listItem.add(BonusConst.UP_BONUS_ALLOWANCE_01);
		listItem.add(BonusConst.UP_BONUS_ALLOWANCE_02);
		listItem.add(BonusConst.UP_BONUS_ALLOWANCE_03);
		listItem.add(BonusConst.UP_BONUS_ALLOWANCE_04);
		listItem.add(BonusConst.UP_BONUS_ALLOWANCE_05);
		listItem.add(BonusConst.UP_BONUS_ALLOWANCE_06);
		listItem.add(BonusConst.UP_BONUS_ALLOWANCE_07);
		listItem.add(BonusConst.UP_BONUS_ALLOWANCE_08);
		listItem.add(BonusConst.UP_BONUS_ALLOWANCE_09);
		listItem.add(BonusConst.UP_BONUS_ALLOWANCE_10);
		listItem.add(BonusConst.UP_BONUS_ALLOWANCE_11);
		listItem.add(BonusConst.UP_BONUS_ALLOWANCE_12);
		listItem.add(BonusConst.UP_BONUS_ALLOWANCE_13);
		listItem.add(BonusConst.UP_BONUS_ALLOWANCE_14);
		listItem.add(BonusConst.UP_BONUS_ALLOWANCE_15);
		listItem.add(BonusConst.UP_BONUS_ALLOWANCE_16);
		listItem.add(BonusConst.UP_BONUS_ALLOWANCE_17);
		listItem.add(BonusConst.UP_BONUS_ALLOWANCE_18);
		listItem.add(BonusConst.UP_BONUS_ALLOWANCE_19);
		listItem.add(BonusConst.UP_BONUS_ALLOWANCE_20);
		listItem.add(BonusConst.UP_BONUS_DEDUCTION_06);
		listItem.add(BonusConst.UP_BONUS_DEDUCTION_07);
		listItem.add(BonusConst.UP_BONUS_DEDUCTION_08);
		listItem.add(BonusConst.UP_BONUS_DEDUCTION_09);
		listItem.add(BonusConst.UP_BONUS_DEDUCTION_10);
		listItem.add(BonusConst.UP_BONUS_DEDUCTION_11);
		listItem.add(BonusConst.UP_BONUS_DEDUCTION_12);
		listItem.add(BonusConst.UP_BONUS_DEDUCTION_13);
		listItem.add(BonusConst.UP_BONUS_DEDUCTION_14);
		listItem.add(BonusConst.UP_BONUS_DEDUCTION_15);
		listItem.add(BonusConst.UP_BONUS_DEDUCTION_16);
		listItem.add(BonusConst.UP_BONUS_DEDUCTION_17);
		listItem.add(BonusConst.UP_BONUS_DEDUCTION_18);
		listItem.add(BonusConst.UP_BONUS_DEDUCTION_19);
		listItem.add(BonusConst.UP_BONUS_DEDUCTION_20);
		String[][] aryItem = new String[listItem.size()][2];
		for (int i = 0; i < listItem.size(); i++) {
			aryItem[i][0] = String.valueOf(i);
			aryItem[i][1] = listItem.get(i);
		}
		return aryItem;
	}
		
	/**
	 * @TvZ(ܗ^f[^XV)
	 * @param vo ΏVO
	 * @throws Exception
	 */
	private void calcLegalDeduction(BonusCalcVo vo) throws Exception {
		// vZmF
//		checkCalcCurrentAfter(vo.getCalcDate());
		// DAO
		PhBounsDao phBounsDao = new PhBounsDao(cfg, cmd, aspUser, user, conn);
		phBounsDao.initDao(cfg, cmd, aspUser, user, conn);
		// Љیݒ
		setSocInsRatio();
		// vZΏۏܗ^f[^擾(xŌ)
//		List<PhBounsDto> listBonus;
//		List<PhBounsDto> listBonus = phBounsDao.findForPayday(vo.getPayday());
//		// vZΏۏܗ^f[^݊mF
//		if (listBonus.size() == 0) {
//			addErrMessage(MospUtility.getMessage(msg, "IC0011", ""));
//			return;
//		}
//		// @TvZ(ܗ^f[^)
//		for (int i = 0; i < listBonus.size(); i++) {
//			// vZΏېݒ
//						phBounsDto = listBonus.get(i);
//			// ЈR[hݒ
//						kCode = phBounsDto.getKCode();
//			// vZNΏ۔Nɐݒ
//			targetMonth = vo.getCalcDate();
//			// @TvZ
//			calcBonusLegalDeduction();
//			// XV
//			pdBonusDao.update(pdBonusDto, false);
//		}
		// R~bg
		commit();
		// bZ[Wݒ
		vo.setMessage(MospUtility.getMessage(msg, BonusConst.MSG_FINISH, BonusConst.NAM_TAX_CALCULATE));
	}

	/**
	 * mvZ(ܗ^f[^XV)
	 * @param vo ΏVO
	 * @throws Exception 
	 */	public void calcTotal(BonusCalcVo vo) throws Exception {
//		// vZmF
//		checkCalcCurrentAfter(vo.getCalcDate());
//		// DAO
//		PhBounsDao dao = new PhBounsDao();
//		dao.initDao(cfg, cmd, aspUser, user, conn);
//		// vZЈ擾
//		List<PhBounsDto> listBonus = dao.findForPayday(vo.getPayday());
//		for (int i = 0; i < listBonus.size(); i++) {
//			phBounsDto = listBonus.get(i);
//			// ЈR[hݒ
//			kCode = phBounsDto.getKCode();
//			// ŋvZς݊mF
//			if (!phBounsDto.getCalcStatus().equals(BonusConst.CALC_STATUS_TAX) &&
//				!phBounsDto.getCalcStatus().equals(BonusConst.CALC_STATUS_EDIT) &&
//				!phBounsDto.getCalcStatus().equals(BonusConst.CALC_STATUS_FIX) &&
//				!phBounsDto.getCalcStatus().equals(BonusConst.CALC_STATUS_FB)
//			) {
//				addErrMessage(MospUtility.getMessage(msg, "WC0026", BonusConst.NAM_TAX_CALCULATE));
//				return;
//			}
//			
//			// mvZ(ܗ^)
//			calcBonusTotal();
//			// rmF
//			chkExclusive(phBounsDto, dao.findForUpdate(pdBonusDto.getKCode(), vo.getCalcDate(), vo.getPayday()), vo);
//			// XV
//			dao.update(pdBonusDto, false);
//		}
//		if (listBonus.size() == 0) {
//			addErrMessage(MospUtility.getMessage(msg, "IC0011", ""));
//			return;
//		}
//		commit();
		// bZ[Wݒ
		vo.setMessage(MospUtility.getMessage(msg, BonusConst.MSG_FINISH, BonusConst.NAM_FIX_ATTENDANCE));

	}

	/**
	 * x̃f[^폜
	 * @param vo ΏVO
	 * @throws Exception
	 */
	public void delete(BonusCalcVo vo) throws Exception {
		// t̑ÓmF
		if (vo.checkTargetDate()) {
			// DAO
			PhBounsDao phBounsDao = new PhBounsDao(cfg, cmd, aspUser, user, conn);
			phBounsDao.initDao(cfg, cmd, aspUser, user, conn);
			// xŃf[^
			List<PhBounsDto > listPhBonus = phBounsDao.findForPayday( vo.getPayday() );
			if (listPhBonus.size() != 0) {
				// xŃf[^폜
				phBounsDao.deleteForPayday(vo.getPayday());
				// R~bg
				commit();
				// bZ[Wݒ
				vo.setMessage(MospUtility.getMessage(msg, MospConst.MSG_DELETE,""));
			} else {
				// Ώۃf[^݂Ȃ
				String errMessage = MospUtility.getMessage(msg, "IC0011", "");
				addErrMessage(errMessage);
				throw new MospException(MospConst.EX_PARAMS_INVALID);
			}
		}
	}
	
	/**
	 * l{擾(G[Ȃ)
	 * @param kCode 擾ΏێЈR[h
	 * @param date  Ώ۔N
	 * @return l{(Employee)
	 * @throws SQLException
	 * @throws NoSuchFieldException
	 * @throws IllegalAccessException
	 * @throws MospException
	 */
	protected Employee getUpdateBasisHistory(
			String kCode, Date date
	) throws SQLException, NoSuchFieldException, IllegalAccessException {
		Employee employee = getEmployee( kCode );
		return employee;
	}


/**---- eBonusActionŎiʉj :: Base ----**/

	/**
	 * ƏR[h擾(M_KAISYA)
	 * @return ƏR[h
	 * @throws SQLException
	 * @throws NoSuchFieldException
	 * @throws IllegalAccessException
	 */
	protected String[][] getStationArrayAll() throws SQLException, NoSuchFieldException, IllegalAccessException {
		// DAȌ
		MKaisyaDao dao = new MKaisyaDao();
		dao.initDao(cfg, cmd, aspUser, user, conn);
		// ̎擾
		List<MKaisyaDto> listStation = dao.findAll();
		// z̍쐬
		String[][] aryStation = new String[listStation.size()][2];
		for (int i = 0; i < listStation.size(); i++) {
			aryStation[i][0] = listStation.get(i).getId();
			aryStation[i][1] = listStation.get(i).getKaiMei();
		}
		return aryStation;
	}
	
	/**
	 * vZ擾
	 * @return vZ
	 * @throws Exception
	 */
	protected Date getCalcCurrent() throws Exception {
		// DAO
		PtCurrentDao dao = new PtCurrentDao(cfg, cmd, aspUser, user, conn);
		dao.initDao(cfg, cmd, aspUser, user, conn);
		PtCurrentDto dto = dao.findForKey(
							PayrollConst.OFFICE_ALL,
							PayrollConst.CALC_BONUS,
							getCurrent(PayrollConst.OFFICE_ALL, PayrollConst.CALC_PAYMENT));
		if (dto != null) {
			return dto.getCalcDate();
		}
		return new Date();
	}

	/**
	 * Nv_E擾(OBonusConstŎw)
	 * @param year N
	 * @return Nv_Epz
	 */
	protected String[][] getYearArrayLong(int year) {
		return getYearArray(year,
				BonusConst.TIME_YEAR_FORMER, BonusConst.TIME_YEAR_FURTHER);
	}
	
	/**
	 * Nv_E擾
	 * @param year N
	 * @return Nv_Epz
	 */
	protected String[][] getYearArray(int year, int former, int further) {
		String[][] aryYear = new String[former + further + 1][2];
		int i = 0;
		int index = 0;
		for (i = year - former; i < year; i++) {
			aryYear[index][0] = String.valueOf(i);
			aryYear[index][1] = String.valueOf(i);
			index++;
		}
		aryYear[index][0] = String.valueOf(year);
		aryYear[index][1] = String.valueOf(year);
		index++;
		for (i = year + 1; i <= year + further; i ++) { 
			aryYear[index][0] = String.valueOf(i);
			aryYear[index][1] = String.valueOf(i);
			index++;
		}
		return aryYear;
	}
	
	/**
	 * vZmF(vZNȍ~)
	 * @param date Ώ۔N
	 * @throws Exception 
	 */
	protected void checkCalcCurrentAfter(Date date) throws Exception {
		if (getCalcCurrent().compareTo(date) > 0) {
			String errMessage = MospUtility.getMessage(msg, BonusConst.MSG_NOT_CURRENT, "");
			addErrMessage(errMessage);
			throw new MospException(BonusConst.EX_NOT_CURRENT, errMessage);
		}
		
/*** bi ***/
		else{
			String errMessage = MospUtility.getMessage(msg, "WU1120", "");
			addErrMessage(errMessage);
			throw new MospException(BonusConst.EX_NOT_CURRENT, errMessage);
		}
	}
	
	/**
	 * NJn擾
	 * @param year N
	 * @return NŏI
	 */
	protected Date getStartDateOfYear(int year) {
		Calendar cal = Calendar.getInstance();
		cal.set(Calendar.YEAR, year);
		cal.set(Calendar.MONTH, 0);
		cal.set(Calendar.DAY_OF_MONTH, 1);
		cal.set(Calendar.HOUR_OF_DAY, 0);
		cal.set(Calendar.MINUTE, 0);
		cal.set(Calendar.SECOND, 0);
		cal.set(Calendar.MILLISECOND, 0);
		return cal.getTime();
	}
	
	/**
	 * NŏI擾
	 * @param year N
	 * @return NŏI
	 */
	protected Date getLastDateOfYear(int year) {
		Calendar cal = Calendar.getInstance();
		cal.set(Calendar.YEAR, year + 1);
		cal.set(Calendar.MONTH, 0);
		cal.set(Calendar.DAY_OF_MONTH, 1);
		cal.set(Calendar.HOUR_OF_DAY, 0);
		cal.set(Calendar.MINUTE, 0);
		cal.set(Calendar.SECOND, 0);
		cal.set(Calendar.MILLISECOND, 0);
		cal.add(Calendar.DAY_OF_MONTH, -1);
		return cal.getTime();
	}

	/**
	 * ЉیlS擾
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public void setSocInsRatio(
	) throws SQLException, IllegalAccessException, NoSuchFieldException {
		// 
		ratioHealthPremium   = 0;	// Nی 
		ratioNursingPremium  = 0;	// ی
		ratioPensionPremium  = 0;	// N
		ratioFundPremium     = 0;	// N
		ratioUnemployPremium = 0;	// ٗpی
		fundParticipation    = LegalConst.FUND_PARTICIPATION_OFF;	// N敪
		// Џ擾
		CmCompanyDao cmCompanyDao = new CmCompanyDao();
		cmCompanyDao.initDao(cfg, cmd, aspUser, user, conn);
		CmCompanyDto cmCompanyDto = cmCompanyDao.findAll();
		if (cmCompanyDto == null) {
			return;
		}
		// ЉیlS擾
		ratioHealthPremium   = cmCompanyDto.getHealthPremiumRate  ();	// Nی  
		ratioNursingPremium  = cmCompanyDto.getNursingPremiumRate ();	// ی
		ratioPensionPremium  = cmCompanyDto.getPensionPremiumRate ();	// N
		ratioFundPremium     = cmCompanyDto.getFundPremiumRate    ();	// N
		ratioUnemployPremium = cmCompanyDto.getUnemployPremiumRate();	// ٗpی
		fundParticipation    = cmCompanyDto.getFundParticipation  ();	// N敪
	}

	/**
	 * @TvZ(Љیyѐŋ̐ݒ)(ܗ^)
	 * @throws Exception
	 */
	protected void calcBonusLegalDeduction() throws Exception {
		// אݒɂzvZ(ېŊzyюЉیΏۊz)
		// ЉیΏۊzݒ
		// Љیݒ
		setBonusSocialInsurance();
		// Őݒ
		setBonusIncomeTax();
		// ZŐݒ͍sȂ
		// m荀ڏ
		phBounsDto.setAllowanceTotal(0);
		phBounsDto.setDeductionTotal(0);
		phBounsDto.setPaymentTotal  (0);
//		phBounsDto.setBank1PayAmount(0);
//		phBounsDto.setBank2PayAmount(0);
//		phBounsDto.setCashPayAmount (0);
//		// Xe[^Xݒ(ŋvZς)
//		phBounsDto.setCalcStatus(BonusConst.CALC_STATUS_TAX);
	}

	/**
	 * Љیݒ(ܗ^)
	 * @throws NoSuchFieldException 
	 */
	private void setBonusSocialInsurance() throws SQLException, IllegalAccessException, NoSuchFieldException {
		int basisHealth   = 0;	// NیvZz
		int basisNursing  = 0;	// یvZz
		int basisPension  = 0;	// NvZz
		//int basisFund     = 0;	// NvZz
		int basisUnemploy = 0;	// ٗpیvZz
		
		int health   = 0;	// Nی
		int nursing  = 0;	// ی
		int pension  = 0;	// N
		//int fund     = 0;	// N
		int unemploy = 0;	// ٗpی
		
		// xz擾(1000~؂̂)
//		int bonusAllowance = (int)round(phBounsDto.calcBonusAllowanceTotal(), - 3, BigDecimal.ROUND_HALF_DOWN); 
		// Nx݌vxz(̎x܂܂Ȃ)
		int totalBonusAmount = (int)round(calcAmountToYearTotal(), - 3, BigDecimal.ROUND_HALF_DOWN);
		// Ώیxz擾
		int targetMonthBonusAmount = (int)round(calcTargetMonthBonusAmount(), - 3, BigDecimal.ROUND_HALF_DOWN);
		
		// l^(ی)擾
		CmSocInsuranceDao dao = new CmSocInsuranceDao();
		dao.initDao(cfg, cmd, aspUser, user, conn);
		CmSocInsuranceDto dto = dao.findForEmployee(kCode, targetMonth);
		// ЉیvZ
		if (dto != null) {
			// NیvZz擾
			basisHealth   = LegalUtility.getBasisHealthPayment(totalBonusAmount, targetMonthBonusAmount);
			// یvZz擾
			basisNursing  =  LegalUtility.getBasisNursingPayment(totalBonusAmount, targetMonthBonusAmount);
			// NvZz擾
			basisPension  =  LegalUtility.getBasisPensionPayment(targetMonthBonusAmount);
/*			// NvZz擾
			basisFund     =  LegalUtility.getBasisFundPayment(targetMonthBonusAmount);
*/			// ٗpیvZz擾
//			basisUnemploy =  LegalUtility.getBasisUnemployPayment(bonusAllowance);
			// ٕۑΏۊzݒ
//			pdBonusDto.setEmpInsBasic(basisUnemploy * 1000);

			// NیvZ(ۏܗ^敪uvZv̏ꍇ)
			if(dto.getBonusHealthType().equals(LegalConst.BONUS_HEALTH_CALC)) {
				health = LegalUtility.calcPremium(basisHealth,
						ratioHealthPremium, BigDecimal.ROUND_HALF_UP);
			}
			// NیvZ(ۏܗ^敪uvZv̏ꍇ)
			if (dto.getBonusHealthType().equals(LegalConst.BONUS_HEALTH_CALC)) {
				// یvZ(ی敪uΏہvuΏ()(Qی҂̂)v̏ꍇ)
				if(chkCalcNursingInsType(dto.getNursingInsType())) {
					nursing = LegalUtility.calcPremium(basisNursing,
							ratioNursingPremium, BigDecimal.ROUND_HALF_UP);
				}
			}
			// NvZ(Nܗ^敪uvZv̏ꍇ)
			if(dto.getBonusPensionType().equals(LegalConst.BONUS_PENSION_CALC)) {
				pension = LegalUtility.calcPremium(basisPension,
						ratioPensionPremium, BigDecimal.ROUND_HALF_UP);
			}
/*			// NvZ(N敪uv̏ꍇ)
			if (fundParticipation.equals(LegalConst.FUND_PARTICIPATION_ON)) {
				// NvZ(Nܗ^敪uvZv̏ꍇ)
				if(dto.getBonusPensionType().equals(LegalConst.BONUS_PENSION_CALC)) {
					fund = LegalUtility.calcPremium(basisFund,
							ratioFundPremium, BigDecimal.ROUND_HALF_UP);
				}
			}
*/			// ٗpیvZ(ٗpی敪uvZv̏ꍇ)
			if (dto.getCalcUnemployType().equals(LegalConst.CALC_UNEMPLOY)) {
				unemploy = LegalUtility.calcPremium(
						basisUnemploy,
						ratioUnemployPremium, BigDecimal.ROUND_HALF_DOWN);
			}
			
			// ΏیɕxĂꍇ͈ȑO̕یċzݒ
			if (0 < befSocInsPremium) {
				health   -= befHealthPremium  ;
				nursing  -= befNursingPremium ;
				pension  -= befPensionPremium ;
			//	fund     -= befFundPremium    ;
			}
			
		}
		// Љیݒ
//		phBounsDto.setHealthInsurance  (health  );
//		phBounsDto.setNursingInsurance (nursing );
//		phBounsDto.setPensionInsurance (pension );
//		phBounsDto.setEmployeeInsurance(unemploy);
		// Nx݌vzݒ
//		phBounsDto.setTotalYearBonus(totalBonusAmount);
	}

	/**
	 * ۂߏ(ľܓ)
	 * @param value Ώےl
	 * @param scale Ώۈʒu(_ȉF0Ő)
	 * @param mode  @
	 * @throws Exception 
	 */
	protected double round(double value, int scale, int mode) {
		BigDecimal bd;
		if (scale >= 0) {
			bd = new BigDecimal(value);
			return bd.setScale(scale, mode).doubleValue();
		}
		int    minusScale = scale * -1;
		double dividing   = 1         ;
		for (int i = 0; i < minusScale; i++) {
			dividing *= 10;
		}
		bd = new BigDecimal(value / dividing);
		return bd.setScale(0, mode).doubleValue() * dividing;
	}

	/**
	 * Nx݌vܗ^z擾
	 * @param vo
	 * @return Nx݌vܗ^z擾
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public int calcAmountToYearTotal() throws SQLException, IllegalAccessException {
		int allBonusAllowance = 0;
		List <PdBonusDto> listBonusDto;
		PdBonusDao dao = new PdBonusDao();
		dao.initDao(cfg, cmd, aspUser, user, conn);
		// 
		Date startDate;
		Date endDate;
		Calendar cal = Calendar.getInstance();
		// Ώ۔Nݒ
		cal.setTime(targetMonth);
		// Nx = Ώ۔N41`N3ŏI
		// ΏۊJn擾
		cal.set(Calendar.MONTH, Calendar.APRIL);
		cal.set(Calendar.DATE, 1);
		startDate = cal.getTime();
		// ΏۍŏI擾
		cal.set(Calendar.MONTH, Calendar.MARCH);
		cal.set(Calendar.DATE, cal.getMaximum(Calendar.DATE));
		cal.add(Calendar.YEAR, 1);
		endDate = cal.getTime();
		// Nxxz擾
		listBonusDto = dao.selectTheYear(kCode,startDate, endDate);
		if (listBonusDto.size() != 0) {
			for (int i = 0; i < listBonusDto.size(); i ++) {
//				PhBounsDto PdBonusDto = listBonusDto.get(i);
//				// x͒ǉȂB
//				if (PdBonusDto.getPayday().compareTo(this.pdBonusDto.getPayday()) != 0) {
//					// ̎xȍ~͒ǉȂ
//					if (PdBonusDto.getPayday().compareTo(this.pdBonusDto.getPayday()) < 0) {
//						// ܂ł̑xz擾
//						allBonusAllowance += PdBonusDto.getAllowanceTotal();
//					}
//				}
			}
		}
		return allBonusAllowance;
	}

	/**
	 * Őݒ(ܗ^)
	 * @throws Exception 
	 */
	public void setBonusIncomeTax() throws Exception {
//		// l^()擾
//		CmIncomeTaxDao cmIncomeTaxDao = new CmIncomeTaxDao();
//		cmIncomeTaxDao.initDao(cfg, cmd, aspUser, user, conn);
//		// ^擾
//		PdPaymentDao PdPaymentDao = new PdPaymentDao();
//		PdPaymentDao.initDao(cfg, cmd, aspUser, user, conn);
//		// ^xԊu擾(Ȃ1)
//		String interval = getConfValue(BonusConst.CONF_ID_PAY_ITBL, BonusConst.CONF_CD_ADJUST_PAY);
//		// Ώ۔N̑O̓t擾
//		befTargetMonth = addMonth(targetMonth, -1 - Integer.parseInt(interval));
//		CmIncomeTaxDto dto = cmIncomeTaxDao.findForEmployeeDate(kCode, befTargetMonth);
//		// l^()݂Ȃꍇ0ݒ
//		if (dto == null) {
//			// ŊzvZyѐݒ
//			pdBonusDto.setIncomeTax(0);
//			// }{̐ݒ
//			pdBonusDto.setDependentCount(0);
//			return;
//		}
//		// }{̐擾
//		int dependent = dto.getDependentCount();
//		// ېŋ敪擾
//		String incomeTaxType = dto.getIncomeTaxType();
//		pdPaymentDto = PdPaymentDao.findForUpdate(kCode, befTargetMonth);
//		// ЉیT̋^̋z擾
//		int payTaxation = pdPaymentDto != null ? pdPaymentDto.getAllowanceTotal() - pdPaymentDto.calcSocialInsurance() : 0;
//		// ېőΏۊz(ܗ^)
//		int bonusTaxation = pdBonusDto.calcBonusAllowanceTotal() - pdBonusDto.calcBonusSocialInsurance();
//		// ŗ擾pz擾
//		double[] aryIncomeTax = LegalUtility.getBonIncomeTaxArray(incomeTaxType, dependent);
//		// ŗݒ
//		pdBonusDto.setIncomeRate((float)LegalUtility.getBonusIncomeRate(aryIncomeTax, payTaxation));
//		
//		// ŊzvZyѐݒ
//		pdBonusDto.setIncomeTax(
//				LegalUtility.calcBonusIncomeTax(incomeTaxType, payTaxation, bonusTaxation, dependent));
//		// }{̐ݒ
//		pdBonusDto.setDependentCount(dependent);
//		// Ő^̋zݒ
//		pdBonusDto.setLastMonthTaxation(payTaxation);
	}

	/**
	 * 
	 * @param date   t
	 * @param amount 
	 * @return t
	 */
	protected Date addMonth(Date date, int amount) {
		Calendar cal = Calendar.getInstance();
		cal.setTime(date);
		cal.set(Calendar.HOUR_OF_DAY, 0);
		cal.set(Calendar.MINUTE, 0);
		cal.set(Calendar.SECOND, 0);
		cal.set(Calendar.MILLISECOND, 0);
		cal.add(Calendar.MONTH, amount);
		return cal.getTime();
	}

	/**
	 * Ώیxz擾
	 * @return Ώیxz
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException 
	 * @throws NoSuchFieldException
	 */
	public int calcTargetMonthBonusAmount() throws SQLException, IllegalAccessException, NoSuchFieldException {
//		int targetMonthBonusAmount = 0;
//		List <PhBounsDto> listBonusDto;
//		PhBounsDao dao = new PhBounsDao(cfg, cmd, aspUser, user, conn);
//		dao.initDao(cfg, cmd, aspUser, user, conn);
//		// Nxxz擾
//		listBonusDto = dao.findForCalcDate(targetMonth, kCode);
//		if (listBonusDto.size() != 0) {
//			for (int i = 0; i < listBonusDto.size(); i ++) {
//				PhBounsDto PhBounsDto = listBonusDto.get(i);
//				// Ώ۔NȑO̎Љی擾
//				if (this.phBounsDto.getPayday().compareTo(PhBounsDto.getPayday()) > 0) {
//					befHealthPremium   = PhBounsDto.getHealthInsurance  ();
//					befNursingPremium  = PhBounsDto.getNursingInsurance ();
//					befPensionPremium  = PhBounsDto.getPensionInsurance ();
//					// Љیv(rp)
//					befSocInsPremium   = befHealthPremium + befNursingPremium + befPensionPremium + befFundPremium;
//				}
//				// Ώ۔N̑xzݒ
//				targetMonthBonusAmount += PhBounsDto.calcBonusAllowanceTotal();
//			}
//		}
//		return targetMonthBonusAmount;
		return 0;
	}

	/**
	 * یvZΏۊmF
	 * @param nursingInsType@ی敪
	 * @return@vZΏۊmFtO
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public boolean chkCalcNursingInsType(String nursingInsType) throws SQLException, IllegalAccessException, NoSuchFieldException {
		boolean isCalc = false;
		// یvZ(ی敪uΏ()v̏ꍇ)
		if (nursingInsType.equals(LegalConst.NURSING_INS_AUTO)) {
			// NŌvZΏۂf
			isCalc = chkCalcNusingInsAuto();
		}
		// یvZ(ی敪uΏہv̏ꍇ)
		if (nursingInsType.equals(LegalConst.NURSING_INS_MANUAL)) {
			isCalc = true;
		}
		return isCalc;
	}

	/**
	 * یvZΏۊmF(敪FvZΏ())
	 * @return vZΏۊmFtO
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	public boolean chkCalcNusingInsAuto() throws SQLException, IllegalAccessException, NoSuchFieldException {
		// vZΏۊmFtO
		boolean isCalc = false;
		// DAO
		PmExtraDao PmExtraDao = new PmExtraDao();
		PmExtraDao.initDao(cfg, cmd, aspUser, user, conn);
		// N擾
		int age = 0;
		// Ώ۔NŏI+1擾
		Date targetDate = addDay(getEndDate(targetMonth), 1);
		// Ǘ擾
		PmExtraDto PmExtraDto = PmExtraDao.findForKey(kCode);
		// Ǘf[^݂ȂЈ͑ΏۊO
		if (PmExtraDto == null) {
			isCalc = false;
			return isCalc;
		}
		// aݒ肳ĂȂЈ͑ΏۊO
		if (PmExtraDto.getBirthDate() == null) {
			isCalc = false;
			return isCalc;
		}
		// N擾(Ώ۔NŏI+1Ŕf)
		age = getAge(PmExtraDto.getBirthDate(), targetDate);
		// 40Έȏ65Ζ͌vZΏ
		if (age >= 40) {
			isCalc = true;
		}
		if (age >= 65 ) {
			isCalc = false;
		}
		return isCalc;
		
	}

	/**
	 * 
	 * @param date   t
	 * @param amount 
	 * @return t
	 */
	protected Date addDay(Date date, int amount) {
		Calendar cal = Calendar.getInstance();
		cal.setTime(date);
		cal.set(Calendar.HOUR_OF_DAY, 0);
		cal.set(Calendar.MINUTE, 0);
		cal.set(Calendar.SECOND, 0);
		cal.set(Calendar.MILLISECOND, 0);
		cal.add(Calendar.DAY_OF_MONTH, amount);
		return cal.getTime();
	}
	
	/**
	 * N擾
	 * @param birthDay
	 * @param targetDay
	 * @return N
	 */
	protected int getAge(Date birthDay, Date targetDay) {
		// 擾
		int age = 0;
		// N擾
		age = MospUtility.getYear(targetDay) - MospUtility.getYear(birthDay);
		// Ώ۔NaNȂ0
		if (age < 0) {
			age = 0;
			return age;
		}
		// Ώیaȍ~
		if (MospUtility.getMonth(targetDay) - MospUtility.getMonth(birthDay) > 0) {
			return age;
		} else if (MospUtility.getMonth(targetDay) - MospUtility.getMonth(birthDay) == 0) {
			
			// Ώۓaȍ~
			if (MospUtility.getDay(targetDay) - MospUtility.getDay(birthDay) > 0) {
				return age;
			} else if (MospUtility.getDay(targetDay) - MospUtility.getDay(birthDay) == 0) {
				// Ώۓa
				return age;
			} else {
				// ΏۓaȑO
				return age - 1;
			}
		} else {
			// ΏیaȑO
			return age - 1;
		}
	}

	/**
	 * WvI擾
	 * @param targetMonth Ώی
	 * @return WvI
	 * @throws NoSuchFieldException 
	 * @throws IllegalAccessException 
	 * @throws SQLException 
	 */
	protected Date getEndDate(
			Date targetMonth
	) throws SQLException, IllegalAccessException, NoSuchFieldException {
		// J_[擾
		Calendar cal = Calendar.getInstance();
		cal.setTime(targetMonth);
		cal.set(Calendar.HOUR_OF_DAY, 0);
		cal.set(Calendar.MINUTE, 0);
		cal.set(Calendar.SECOND, 0);
		cal.set(Calendar.MILLISECOND, 0);
		// ߓ擾
		String[][] close = getConfArray(BonusConst.CONF_ID_CLOSE);
		int minusMonth = Integer.parseInt(close[0][0]);
		int closeDay   = Integer.parseInt(close[0][1]);
		// WvIvZ
		cal.roll(Calendar.MONTH, minusMonth * -1);
		if (closeDay != 0) {
			cal.roll(Calendar.MONTH, 1);
			cal.set(Calendar.DAY_OF_MONTH, closeDay);
		} else {
			cal.roll(Calendar.DAY_OF_MONTH, -1);
		}
		return cal.getTime();
	}

	/**
	 * ݒ胊Xg擾(UM_CONF)
	 * @param confId ݒ敪
	 * @return ݒ胊Xg
	 * @throws NoSuchFieldException 
	 * @throws IllegalAccessException 
	 * @throws SQLException 
	 */
	protected String[][] getConfArray(
			String confId
	) throws SQLException, IllegalAccessException, NoSuchFieldException {
		// DAO̐錾
		MosPConfDao dao = new MosPConfDao();
		dao.initDao(cfg, cmd, aspUser, user, conn);
		// f[^̎擾
		List<MosPConfDto> list = dao.findForCondition(confId);
		// f[^̐`
		String[][] array = new String[list.size()][2];
		for (int i = 0; i < list.size(); i++) {
			MosPConfDto dto = list.get(i);
			array[i][0] = dto.getConfCode();
			array[i][1] = dto.getConfValue();
		}
		return array;
	}

	/**
	 * mvZ(vyыsU)(ܗ^)
	 * @throws Exception
	 */
	protected void calcBonusTotal() throws Exception {
//		// Őݒ
//		setBonusIncomeTax();
//		// mvZ
//		int allowance = 0;	// xz
//		int deduction = 0;	// Tz
//		int total     = 0;	// xz
//		// xz擾
//		allowance = phBounsDto.calcBonusAllowanceTotal();
//		// Tz擾
//		deduction = phBounsDto.calcBonusDeductionTotal();
//		// xzvZ(xz-Tz)
//		total = allowance - deduction; 
//		// sU
//		divideAmongAccounts(total, BonusConst.ALLOWANCE_TYPE_BONUS);
//		// mݒ
//		phBounsDto.setAllowanceTotal(allowance  );
//		phBounsDto.setDeductionTotal(deduction  );
//		phBounsDto.setPaymentTotal  (total      );
//		// xz}CiX̏ꍇ͋s1As2A̒l0ɐݒ肷
//		if (total < 0) {
//			phBounsDto.setBank1PayAmount(0);
//			phBounsDto.setBank2PayAmount(0);
//			phBounsDto.setCashPayAmount (0);
//		} else {
//			phBounsDto.setBank1PayAmount(bank1Amount);
//			phBounsDto.setBank2PayAmount(bank2Amount);
//			phBounsDto.setCashPayAmount (cashAmount );
//		}
//		// Xe[^Xݒ(m菈ς)
//		phBounsDto.setCalcStatus(BonusConst.CALC_STATUS_FIX);
	}

	/**
	 * אݒ擾B(ܗ^)<br>
	 * @return אݒ
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	protected Map<String, PsDetailDto> getMapBonusDetail(
	) throws SQLException, IllegalAccessException, NoSuchFieldException {
		// אݒ擾
//		if (mapBonusDetailAll == null) {
//			PsDetailDao PsDetailDao = new PsDetailDao();
//			PsDetailDao.initDao(cfg, cmd, aspUser, user, conn);
//			mapBonusDetailAll = PsDetailDao.findBonusAsMap();
//		}
		// אݒL[
//		String key = phBounsDto.getEmploymentType() + BonusConst.KEY_SEPARATOR;
//		// L[+EʃR[hŖאݒ擾
//		Map<String, PsDetailDto> mapDetail =
//			mapBonusDetailAll.get(key + phBounsDto.getPositionCode());
//		// L[+EʃR[hŖאݒ肪Ȃꍇ
//		if (mapDetail == null) {
//			// L[+ݒȂŖאݒ擾
//			mapDetail = mapBonusDetailAll.get(key + BonusConst.SETTING_NONE);
//		}
//	return mapDetail;
	return null;
	}

	/**
	 * sU
	 * @param total         xz
	 * @param allowanceType x敪(1F^A2Fܗ^)
	 * @throws SQLException
	 * @throws IllegalAccessException
	 * @throws NoSuchFieldException
	 */
	protected void divideAmongAccounts(
			int total, String allowanceType
	) throws SQLException, IllegalAccessException, NoSuchFieldException {
		// 
		bank1Amount = 0;
		bank2Amount = 0;
		cashAmount  = 0;
		// DAO
		CmPaymentMeansDao dao = new CmPaymentMeansDao();
		dao.initDao(cfg, cmd, aspUser, user, conn);
		// x@擾(x@Aԏ)
		List<CmPaymentMeansDto> list;
		list = dao.findForEmployeeAllowance(kCode, allowanceType);
		// x񖈂̏
		int currentAmount = total;
		for (Iterator<CmPaymentMeansDto> it = list.iterator(); it.hasNext();) {
			CmPaymentMeansDto dto = it.next();
			// Uz擾
			int amount = getdividedAmount(dto, total, currentAmount);
			// Uzݒ
			if (dto.getPaymentMeans().equals(BonusConst.PAYMENT_MEANS_ACCOUNT)) {
				// Ȕꍇ
				if (dto.getMeansSequence() == BonusConst.PAYMENT_MEANS_SEQ_1
						|| dto.getMeansSequence() == BonusConst.PAYMENT_MEANS_SEQ_3) {
					bank1Amount += amount;
				} else {
					bank2Amount += amount;
				}
			} else {
				// UȊO()̏ꍇ
				cashAmount += amount;
			}
			// czvZ
			currentAmount -= amount;
		}
		// czɐݒ
		cashAmount += currentAmount;
	}

	/**
	 * Uxz擾
	 * @param dto           x@DTO
	 * @param totalAmount   Uz
	 * @param currentAmount Uz(cz)
	 */
	private int getdividedAmount(
			CmPaymentMeansDto dto, int totalAmount, int currentAmount
	) {
		// x񂪐ݒ肳ĂȂꍇ
		if (dto == null) {
			return 0;
		}
		// Sz̏ꍇ
		if (dto.getAmountType().equals(BonusConst.AMOUNT_TYPE_ALL)) {
			return currentAmount;
		}
		// cz̏ꍇ
		if (dto.getAmountType().equals(BonusConst.AMOUNT_TYPE_REST)) {
			return currentAmount;
		}
		// Uxz
		int dividingAmount = 0;
		// z敪̏
		if (dto.getAmountType().equals(BonusConst.AMOUNT_TYPE_AMOUNT)) {
			// z̏ꍇ
			dividingAmount = dto.getFixedAmount();
		} else if (dto.getAmountType().equals(BonusConst.AMOUNT_TYPE_RATIO)) {
			// 藦̏ꍇ
			// Uz * U / 100
			dividingAmount = (int)round(
					dto.getFixedAmount() / 100 * totalAmount,
					0, BigDecimal.ROUND_HALF_UP);
		}
		// Uzȏ̏ꍇ
		if (dividingAmount > currentAmount) {
			dividingAmount = currentAmount;
		}
		return dividingAmount;
	}
	
}
